<?php

use Illuminate\Database\Migrations\Migration;
use Inside\AGRE\Observers\SubscriberContentsObserver;
use Inside\Content\Models\Contents\SubscriberContents;
use Inside\Notify\Models\NotificationType;

class CreateNotificationOnSubscriberContent extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate([
            'via'       => 'web',
            'type'      => 'system',
            'default'   => false,
            'event'     => null,
            'model'     => SubscriberContents::class,
            'action'    => 'create',
            'condition' => null,
            'multiple'  => false,
            'language'  => false,
            'profile'   => false,
            'data'      => [
                'title'       => 'notifications.agre.content_added.title',
                'description' => 'notifications.agre.content_added.description',
                'text'        => 'notifications.agre.content_added.text'
            ]
        ]);
    }
}
