<?php

namespace Inside\AGRE\Observers;

use Inside\AGRE\Actions\NotifyUserOfSubscriberContent;
use Inside\Content\Models\Contents\SubscriberContents;

class SubscriberContentsObserver
{
    /**
     * Handle the SubscriberContents "created" event.
     *
     * @param  SubscriberContents  $subscriberContents
     * @return void
     */
    public function created(SubscriberContents $subscriberContents): void
    {
        (new NotifyUserOfSubscriberContent())($subscriberContents, 'create');
    }

    /**
     * Handle the SubscriberContents "updated" event.
     *
     * @param  SubscriberContents  $subscriberContents
     * @return void
     */
    public function updated(SubscriberContents $subscriberContents): void
    {
        (new NotifyUserOfSubscriberContent())($subscriberContents, 'update');
    }
}
