<?php

namespace Inside\AGRE\Mails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Lang;

class SubscriberContentPublished extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build(): self
    {
        return $this
            ->markdown('emails.subscriber_content')
            ->subject(Lang::get('notifications.agre.content_added.title'))
            ->with(
                [
                    'content' => Lang::get('email.agre.content_added.description'),
                    'url' => url('mon-abonnement'),
                    'button' => Lang::get('email.agre.document.button'),
                ]
            );
    }
}
