<?php

use Drupal\field\Entity\FieldConfig;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateContentTypeCities extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('cities', false);
        $this->finishUp();

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'cities',
            [
                'name' => 'cities',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => true,
                'search_filter' => true,
                'required' => false,
                'weight' => 21,
                'title' => [
                    'fr' => 'Ville',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 21,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['cities'],
                    'cardinality' => 1,
                ],
            ],
        );

        $bridge->contentTypeUpdateField(
            'users',
            'function',
            [
                'name' => 'function',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Fonction',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
        );
    }
}
