<?php

use Drupal\Core\Entity\EntityStorageException;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Exceptions\ColumnAlreadyExistsException;

class AddWebsiteFieldToUser extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     * @throws EntityStorageException|ColumnAlreadyExistsException
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('users', 'website', [
            'name' => 'website',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 20,
            'title' => [
                'fr' => 'Site internet',
            ],
            'description' => [
                'fr' => 'Site internet de l\'agence',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 20,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'default' => "",
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     * @throws EntityStorageException
     */
    public function down(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('users', 'user', 'website');
    }
}
