import SpacePage from '../pages/spaces/SpacePage'

import PedagonewsPage from '../pages/pedagonews/PedagonewsPage'

import { franchisedSpacesGuard } from '../guards'

import { fetchPedagonews } from '../fetch'

import { fetchSpace } from '../pages/spaces/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      itemsPerPage: 4
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    component: () => import('../pages/GedPage'),
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/users/DirectoryPage')
  },
  {
    path: '/espaces',
    name: 'SpacesListing',
    component: () => import('../pages/spaces/SpacesListingPage'),
    meta: { middleware: franchisedSpacesGuard }
  },
  {
    path: '/espaces/:slug',
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl' })(fetchSpace),
    meta: { middleware: franchisedSpacesGuard }
  },
  {
    name: 'SpaceVisitReport',
    path: '/espaces/:slug/:rapport',
    component: () => import('../pages/spaces/VisitReportPage'),
    meta: { middleware: franchisedSpacesGuard }
  },
  {
    name: 'AddFranchisedSpacesFolders',
    path: '/add-franchised-spaces-folders',
    component: () => import('../pages/FranchisedSpaceFolderEditionPage')
  },
  {
    name: 'EditFranchisedSpacesFolders',
    path: '/edit-franchised-spaces-folders',
    component: () => import('../pages/FranchisedSpaceFolderEditionPage')
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'PedagonewsListingPage',
    path: '/pedagonews',
    component: () => import('../pages/pedagonews/PedagonewsListingPage'),
    meta: { customSlug: 'pedagonews' }
  },
  {
    name: 'PedagonewsPage',
    path: '/pedagonews/:slug',
    component: withFetch(PedagonewsPage, { size: 'xxl' })(fetchPedagonews)
  },
  {
    name: 'ProfileUser',
    component: () => import('../pages/profile/ProfileUserPage')
  }
]
