import { http } from '@inside-library/helpers/Http'

const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/franchised_spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'banner',
        {
          collaborators: [
            'uuid',
            'image',
            'firstname',
            'lastname',
            'function',
            'phone',
            'users_status'
          ]
        },
        'description',
        'franchised',
        'image',
        'city',
        'content_type',
        { departments: ['uuid', 'title'] }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchSpace }
