import { getContentImage } from '@inside-library/helpers/Image'

export default {
  'inside-edition': {
    duplicateEnabled: true
  },
  'inside-layouts': {
    gdprContent: 'popin',
    templates: {
      fullContent: {
        articles: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          relatedComponent: () => import('@inside-news/components/lib/Minimal')
        }
      }
    }
  },
  'inside-news': {
    showBookmarks: false
  },
  'inside-events': {
    subscriptionEnabled: true
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'password', restrictions: [] },
        { name: 'contents', restrictions: [], icon: 'edit' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/directory/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'avatar')
        }),
        selectionConfig: {
          fields: [
            'uuid_host',
            'firstname',
            'lastname',
            'phone',
            'function',
            'users_status',
            'image'
          ],
          filters: {
            'status:eq': 1,
            sort: 'lastname:asc',
            'is_maintenance:eq': 0
          }
        },
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'function',
          'users_status',
          'image'
        ]
      }
    }
  },
  'inside-ged': {
    rootRoute: {
      fr: 'base-documentaire'
    }
  }
}
