import { http } from '@inside-library/helpers/Http'

export const fetchPedagonews = async ({ $route }) => {
  const ilnpFields = [
    'uuid',
    'title',
    'content_type',
    'slug',
    'published_at',
    'updated_at',
    'image',
    'chapo',
    'content'
  ]

  try {
    const { data } = await http.get('content/newsletters_pedagonews', {
      fields: [
        'title',
        'nl_introduction',
        'uuid',
        {
          ilnp_articles: { ...ilnpFields, folders: 'folders' }
        },
        {
          ilnp_events: ilnpFields
        },
        {
          ilnp_news: ilnpFields
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
