import { http } from '@inside-library/helpers/Http'
import get from 'lodash/get'

export default {
  infosFlash: {
    add: () => ({ path: '/' }),
    delete: () => ({ path: '/' })
  },
  articles: {
    add: async ({ data }) => {
      const { data: articles } = await http.get('content/articles', {
        fields: ['uuid', { folders: ['uuid', 'title'] }],
        filters: { 'slug:eq': data.slug[0] }
      })

      const article = articles[0]

      return {
        name: 'GedPage',
        query: {
          contentType: 'articles',
          uuid: article.uuid,
          modal: 'articles',
          folder: article.folders.uuid,
          size: 'l'
        }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/articles', {
          fields: [
            {
              folders: {
                fields: ['uuid', 'title'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        const folder =
          get(data, [0, 'folders', 'uuid']) ||
          get(data, [0, 'folders', 'data', 0, 'uuid'])

        return {
          name: 'GedPage',
          query: { folder }
        }
      } catch (err) {
        return { name: 'GedPage' }
      }
    }
  },
  franchisedSpaces: {
    add: ({ data }) => ({
      name: 'Space',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'SpacesListing' })
  },
  visitReport: {
    fields: [{ spaces: ['slug'] }],
    add: async ({ fields, data }) => {
      try {
        const { data: dataSpace } = await http.get(
          'content/franchised_spaces',
          {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'status:eq': 1, 'uuid:eq': fields.franchised_spaces }
          }
        )

        return {
          name: 'SpaceVisitReport',
          params: { slug: dataSpace[0].slug[0], rapport: data.slug[0] }
        }
      } catch (err) {
        return { name: 'SpacesListing' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/visit_report', {
          fields: [
            {
              franchised_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        const slug =
          get(data, [0, 'franchised_spaces', 'slug', 0]) ||
          get(data, [0, 'franchised_spaces', 'data', 0, 'slug', 0])

        return {
          name: 'Space',
          params: { slug }
        }
      } catch (err) {
        return { name: 'SpacesListing' }
      }
    }
  },
  franchisedSpacesFolders: {
    add: async ({ fields }) => {
      try {
        const { data } = await http.get('content/franchised_spaces_folders', {
          fields: [
            {
              franchised_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': fields.franchised_spaces_folders }
        })

        const slug = get(data, [0, 'franchised_spaces', 'slug', 0])

        return {
          name: 'Space',
          params: { slug }
        }
      } catch (err) {
        return { name: 'SpacesListing' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/franchised_spaces_folders', {
          fields: [
            'uuid',
            'title',
            {
              franchised_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        const slug =
          get(data, [0, 'franchised_spaces', 'slug', 0]) ||
          get(data, [0, 'franchised_spaces', 'data', 0, 'slug', 0])

        return {
          name: 'Space',
          params: { slug }
        }
      } catch (err) {
        return { name: 'SpacesListing' }
      }
    }
  },
  franchisedSpacesDocuments: {
    add: async ({ fields }) => {
      try {
        const { data } = await http.get('content/franchised_spaces_folders', {
          fields: [
            'uuid',
            'title',
            {
              franchised_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': fields.franchised_spaces_folders }
        })

        const slug =
          get(data, [0, 'franchised_spaces', 'slug', 0]) ||
          get(data, [0, 'franchised_spaces', 'data', 0, 'slug', 0])

        return {
          name: 'Space',
          params: { slug }
        }
      } catch (err) {
        return { name: 'SpacesListing' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data } = await http.get('content/franchised_spaces_documents', {
          fields: [
            'uuid',
            'title',
            {
              franchised_spaces_folders: {
                fields: [
                  'uuid',
                  'title',
                  'slug',
                  {
                    franchised_spaces: {
                      fields: ['uuid', 'title', 'slug'],
                      filters: { 'status:eq': 1 }
                    }
                  }
                ],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })

        const slug = get(data, [
          0,
          'franchised_spaces_folders',
          'franchised_spaces',
          'slug',
          0
        ])

        return {
          name: 'Space',
          params: { slug }
        }
      } catch (err) {
        return { name: 'SpacesListing' }
      }
    }
  },
  newslettersPedagonews: {
    add: async ({ data }) => {
      const { data: pedagonews } = await http.get(
        'content/newsletters_pedagonews',
        {
          fields: ['uuid'],
          filters: { 'slug:eq': data.slug[0] }
        }
      )

      const pedagonewsUuid = pedagonews[0].uuid

      return {
        name: 'AdminMailingsPreviewPage',
        params: { uuid: pedagonewsUuid }
      }
    },
    delete: () => ({ name: 'AdminMailingsListPage' })
  }
}
