import { storage } from '@inside-library/helpers/Storage'
import { isSuperAdmin, isAdmin } from '@inside-library/helpers/Rights'

const isEditionRole = () => {
  const user = storage.get('current-user')

  return (
    isSuperAdmin() ||
    isAdmin() ||
    user.permissions.roles.includes('Rédacteur en chef') ||
    user.permissions.roles.includes('Rédacteur')
  )
}

const isFranchisedUser = () => {
  const user = storage.get('current-user')
  return user.permissions.roles.includes('Franchisé')
}

export { isEditionRole, isFranchisedUser }
