<?php

namespace Inside\AGFR\Listeners;

use Exception;
use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\AGFR\Facades\FranchisedCustomFolders;
use Inside\Content\Models\Contents\FranchisedSpaces;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Host\Bridge\BridgeContent;

class FranchisedSpacesListeners implements ShouldQueue
{
    /**
     * @throws Exception
     */
    public function handle(ContentFullyInsertedEvent $event): void
    {
        if (!$event->model instanceof FranchisedSpaces) {
            return;
        }

        $bridge = new BridgeContent();

        $rootUuidFolders = $bridge->contentInsert('franchised_spaces_folders', [
            'type' => 'node',
            'bundle' => 'franchised_spaces_folders',
            'title' => 'Home',
            'franchised_spaces' => [$event->model->uuid],
        ]);

        $uuid = $bridge->contentInsert('franchised_spaces_folders', [
            'type' => 'node',
            'bundle' => 'franchised_spaces_folders',
            'title' => 'Confidentiel',
            'franchised_spaces' => [$event->model->uuid],
            'author' => $event->model->author,
            'franchised_spaces_folders' => $rootUuidFolders,
        ]);

        FranchisedCustomFolders::setPermissions(
            $uuid,
            [
                1, // Super admin
                4, // Admin
                11, // Rédacteur en chef
                12, // Rédacteur
            ],
            [
                10, // Franchisé
            ]
        );
    }
}
