<?php

return [
    '_meta' => [
        'type' => 'newsletters_pedagonews',
    ],
    'banner' => [
        'backgroundColor' => '#fff',
        'backgroundImageUrl' => 'vendor/maecia/agfr-back/resources/assets/newsletter/pedagonews_header.png',
    ],
    'introduction' => [
        'introductionFieldName' => 'nl_introduction',
        'showGreetings' => false,
    ],
    'sections' => [
        'news' => [
            'sectionType' => 'fullcontent',
            'types' => ['news'],
            'imageStyle' => 'image-section',
            'defaultImageUrl' => 'vendor/maecia/agfr-back/resources/assets/newsletter/news-default.png',
            'dateFormat' => '%d/%m/%Y',
            'dateFieldName' => 'updated_at',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionTextColor' => '#AF1F50',
            ],
        ],
        'events' => [
            'sectionType' => 'fullcontent',
            'types' => ['events'],
            'imageStyle' => 'image-section',
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#AF1F50',
            'link' => [
                'sectionLinkUrl' => 'evenements',
                'sectionTextColor' => '#AF1F50',
            ],
        ],
        'articles' => [
            'sectionType' => 'fullcontent',
            'types' => ['articles'],
            'imageStyle' => 'image-section',
            'dateFormat' => '%d/%m/%Y',
            'dateFieldName' => 'updated_at',
            'parentFieldName' => 'folders',
            'leftLineColor' => '#AF1F50',
            'sectionTitleStrKey' => 'newsletter.pedagonews.articles_title',
            'defaultImageActive' => false,
            'link' => [
                'sectionLinkUrl' => 'base-documentaire',
                'sectionTextColor' => '#AF1F50',
            ],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#AF1F50',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/AgendaDiagnosticImmobilier',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/user/AGENDADIAGNOSTICS',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/agenda-diagnostics',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/agenda_diagnostics',
            ],
        ],
    ],
    'footer' => [
    ],
];
