<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Tools;

final class UpdateToolsCardinalityForAgfr extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: 'tools',
            fieldName: 'tools_categories',
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'tools',
            fieldName: 'tools_categories',
            options: [
                'name' => 'tools_categories',
                'searchable' => true,
                'global_searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'required' => true,
                'weight' => 5,
                'title' => [
                    'fr' => 'Categories d\'outils'
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['tools_categories'],
                    'cardinality' => 1,
                ],
            ],
            weight: 5
        );

        Artisan::call('models:rebuild');
    }
}
