<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\UsersStatus;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateUsersStatuses extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            'users_status',
            'allowed_statuses',
            [
                'name' => 'allowed_statuses',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Autres statuts ayant accès',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                ],
                'settings' => [
                    'target_type' => ['users_status'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
        );

        $this->getBridge()?->updateContentTypeOptions('users_status', ['listing_type' => 'content']);

        $bridge = new BridgeContent();
        $usersStatuses = UsersStatus::pluck('uuid');

        $usersStatuses->each(fn (string $uuid) => $bridge->contentUpdate('users_status', ['uuid' => $uuid, 'allowed_statuses' => $usersStatuses->all()]));

        $this->finishUp();
    }
}
