<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddOldIdFieldForImport extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $contentTypes = ['folders', 'articles'];

        foreach ($contentTypes as $contentType) {
            $this->bridge->contentTypeCreateOrUpdateField($contentType, 'old_id', [
                'name' => 'old_id',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Ancien ID',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ]);
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
