<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateCommentsInReportVisite extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'visit_report',
            'comments',
            [
                'name' => 'comments',
                'searchable' => false,
                'translatable' => false,
                'default' => [],
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Commentaires'
                ],
                'description' => [
                    'fr' => ''
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::COMMENT_FIELD,
                'settings' => [
                    'comment_type' => 'comments',
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
