<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'listing_type' => 'content',
        'permissible' => true,
        'categorizable' => false,
        'name' => 'franchised_spaces',
        'title' => [
            'fr' => 'Espace franchisé'
        ],
    ],
    'fields' => [
        [
            'name' => 'description',
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Description',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'banner',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Bannière',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => $weight++,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => $weight++,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'departments',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Département',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'target_type' => ['departments'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'city',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Ville agence',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'franchised',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Franchisés',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
            'selectable_all' => false,
        ],
        [
            'name' => 'collaborators',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Collaborateurs',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
            'selectable_all' => false,
        ],
    ],
];
