<?php

namespace Inside\AGFR\Providers;

use Inside\AGFR\Console\ImportFranchisedSpaceCommand;
use Inside\AGFR\Console\PurgeGedCommand;
use Inside\AGFR\Console\ImportGedCommand;
use Inside\AGFR\Http\Middlewares\UsersDirectoryPermissionMiddleware;
use Inside\AGFR\Listeners\FranchisedSpacesListeners;
use Inside\Application;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * AGFR Service provider.
 *
 * @category Class
 * @package  Inside\AGFR\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentFullyInsertedEvent::class => [
            FranchisedSpacesListeners::class,
        ],
    ];

    protected array $commands = [
        ImportGedCommand::class,
        PurgeGedCommand::class,
        ImportFranchisedSpaceCommand::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/permission.php', 'permission');
            $this->mergeConfigTo(__DIR__.'/../../config/newsletters.php', 'newsletters');
            $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
            $this->mergeConfigFrom(__DIR__.'/../../config/contents_import.php', 'contents_import');
            $this->mergeConfigFrom(__DIR__.'/../../config/franchised_space.php', 'franchised_space');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
            $this->mergeConfigTo(__DIR__.'/../../config/feed.php', 'feed');

            $this->mergeRecursiveConfigFrom(
                __DIR__.'/../../config/scheduler.php',
                'scheduler'
            );
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->middleware([UsersDirectoryPermissionMiddleware::class]);
    }
}
