<?php

namespace Inside\AGFR\Console;

use Illuminate\Console\Command;
use Inside\Host\Bridge\BridgeContent;

class PurgeGedCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'agfr:ged:purge';

    /**
     * @var string
     */
    protected $signature = 'agfr:ged:purge';

    /**
     * @var string
     */
    protected $description = 'Delete all imported contents';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function handle(): void
    {
        $bridge  = new BridgeContent();

        $contentTypes = ['folders', 'articles'];

        foreach ($contentTypes as $contentType) {
            $contents = call_user_func(type_to_class($contentType) . '::query')->whereNotNull('old_id')->orWhere('old_id', '>', 0)->get();

            $bar = $this->getOutput()->createProgressBar($contents->count());
            $bar->setFormat("%message%\n %current%/%max% [%bar%] %percent:3s%%");

            foreach ($contents as $content) {
                $bar->setMessage(sprintf('Deleting %s content [%s] (%s)', $contentType, trim($content->title), $content->old_id));
                $bar->advance();
                $bridge->contentDelete($contentType, $content->uuid);
            }
        }
    }
}
