<?php

return [
    '_meta' => [
        'type' => 'newsletters',
    ],
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/agfr-back/resources/assets/newsletter/logo.png',
        'logoWidth' => 170,
        'showDate' => true,
        'dateColor' => '#a7a7a7',
        'dateFormat' => '%A %d %B %Y',
    ],
    'banner' => [
        'backgroundImageUrl' => 'vendor/maecia/agfr-back/resources/assets/newsletter/header.jpg',
        'backgroundColor' => '#ffff',
    ],
    'introduction' => [
        'introductionFieldName' => 'nl_introduction',
    ],
    'sections' => [
        'news' => [
            'types' => ['news'],
            'defaultImageUrl' => 'vendor/maecia/agfr-back/resources/assets/newsletter/news-default.png',
            'dateFormat' => '%d %B %Y',
            'dateFieldName' => 'updated_at',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionArrowUrl' => 'vendor/maecia/agfr-back/resources/assets/newsletter/arrow-right.png',
                'sectionTextColor' => '#AF1F50',
            ],
        ],
        'events' => [
            'types' => ['events'],
            'dateFormat' => '%d %B %Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#AF1F50',
            'link' => [
                'sectionLinkUrl' => 'evenements',
                'sectionArrowUrl' => 'vendor/maecia/agfr-back/resources/assets/newsletter/arrow-right.png',
                'sectionTextColor' => '#AF1F50',
            ],
        ],
        'documents' => [
            'types' => ['documents'],
            'parentFieldName' => 'folders',
            'leftLineColor' => '#AF1F50',
            'link' => [
                'sectionLinkUrl' => 'base-documentaire',
                'sectionArrowUrl' => 'vendor/maecia/agfr-back/resources/assets/newsletter/arrow-right.png',
                'sectionTextColor' => '#AF1F50',
            ],
        ],
        'articles' => [
            'sectionType' => 'documents',
            'types' => ['articles'],
            'parentFieldName' => 'folders',
            'leftLineColor' => '#AF1F50',
            'dateFieldName' => 'updated_at',
            'link' => [
                'sectionLinkUrl' => 'base-documentaire',
                'sectionArrowUrl' => 'vendor/maecia/agfr-back/resources/assets/newsletter/arrow-right.png',
                'sectionTextColor' => '#AF1F50',
            ],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#AF1F50',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/AgendaDiagnosticImmobilier',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/user/AGENDADIAGNOSTICS',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/agenda-diagnostics',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/agenda_diagnostics',
            ],
        ],
    ],
    'footer' => [
    ],
];
