<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

final class AddEndDateToInfosFlash extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'infos_flash',
            fieldName: 'end_date',
            options: [
                'name' => 'end_date',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Date de fin',
                    'en' => 'End date',
                    'es' => 'Fecha final',
                    'de' => 'Endtermin',
                    'pt' => 'Data final',
                    'nl' => 'Einddatum',
                ],
                'description' => [
                    'fr' => 'Choix de la date et heure de dépublication du flash info',
                    'en' => 'Choice of the date and time of depublication of the flash info',
                    'es' => 'Elección de la fecha y hora de publicación de la información flash',
                    'de' => 'Wahl des Datums und der Uhrzeit der Veröffentlichung der Flash-Info',
                    'pt' => 'Escolha da data e hora da publicação da notícia flash',
                    'nl' => 'Keuze van datum en tijd van het depublicatie van de infl fash',
                ],
                'widget' => [
                    'type' => BridgeContentType::TIMESTAMP_WIDGET,
                    'settings' => [],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::TIMESTAMP_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            weight: 5
        );
    }
}
