<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateDocumentsContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'documents',
            fieldName: 'content',
            options: [
                'name' => 'content',
                'type' => BridgeContentType::SECTION_FIELD,
                'settings' => [
                    'target_type' => [
                        'text',
                        'text_with_image',
                        'image',
                        'file',
                        'slider',
                    ],
                    'cardinality' => -1,
                ],
            ],
        );

        $this->finishUp();
    }
}
