<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldNameMachine extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'users_status',
            'name_machine',
            [
                'name' => 'name_machine',
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Nom machine'
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
