<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateTypesFieldsCitySectorsCpDepartments extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'franchised_spaces', 'sectors');
        $bridge->contentTypeDeleteField('node', 'franchised_spaces', 'city');
        $bridge->contentTypeDeleteField('user', 'user', 'sectors');
        $bridge->contentTypeDeleteField('user', 'user', 'city');

        $bridge->contentTypeCreateOrUpdateField('franchised_spaces', 'sectors', [
            'name' => 'sectors',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Secteur',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 2,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
        $bridge->contentTypeCreateOrUpdateField('franchised_spaces', 'city', [
            'name' => 'city',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Ville',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 3,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
        $bridge->contentTypeCreateOrUpdateField('franchised_spaces', 'zip', [
            'name' => 'zip',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Code postal',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 4,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('users', 'sectors', [
            'name' => 'sectors',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Secteur',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 2,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
        $bridge->contentTypeCreateOrUpdateField('users', 'city', [
            'name' => 'city',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Ville',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 3,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
        $bridge->contentTypeCreateOrUpdateField('users', 'zip', [
            'name' => 'zip',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Code postal',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 4,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
