<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddVisibleFieldOnArticles extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->bridge->contentTypeCreateOrUpdateField('articles', 'visible', [
            'name' => 'visible',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 121,
            'title' => [
                'fr' => 'Visible pour les employés',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 121,
                'group' => 'group_options',
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => true,
        ]);

        $this->finishUp();
    }

    public function down(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeDeleteField('node', 'articles', 'visible');
    }
}
