<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ChangeFieldCityAndDepartments extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeDeleteField('node', 'franchised_spaces', 'city');
        $bridge->contentTypeDeleteField('node', 'franchised_spaces', 'departments');

        $bridge->contentTypeCreateOrUpdateField('franchised_spaces', 'city', [
            'name' => 'city',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Ville',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => 6,
            ],
            'settings' => [
                'target_type' => ['city'],
                'cardinality' => -1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('franchised_spaces', 'departments', [
            'name' => 'departments',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Département',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'weight' => 6,
            ],
            'settings' => [
                'target_type' => ['departments'],
                'cardinality' => -1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
