<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ChangeTypeFieldSectors extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeDeleteField('user', 'users', 'sectors');

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'sectors',
            [
                'name' => 'sectors',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Secteur',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 6,
                ],
                'settings' => [
                    'target_type' => 'sectors',
                    'cardinality' => -1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
