<?php

use Inside\Permission\Models\User;

return [
    'locked' => [
        'Franchisé'
    ],
    'apply_permission_scope' => function ($user, $model) {
        if (class_to_type((string) get_class($model)) === 'articles') {
            return false;
        }

        return true;
    },
    'global_scope' => function (&$builder, $user, $model) {
        if (class_to_type((string) get_class($model)) === 'articles') {
            /** @var User $permissionUser */
            $permissionUser = User::query()->find($user->uuid);
            $roles = $permissionUser->roles->where('name', '<>', 'authenticated')->pluck('name')->toArray();

            if (empty($roles)) {
                $builder->where('inside_content_articles.visible', '=', true);
            }
        }
    },
];
