<?php

use Illuminate\Database\Query\Builder;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\UsersStatus;
use Inside\Content\Models\Model;
use Inside\Host\Bridge\BridgeContent;

if (!function_exists('get_string')) {
    function get_string(array $record, string $column): ?string
    {
        if (array_key_exists($column, $record) && !empty(trim($record[$column]))) {
            return trim('0'.$record[$column]);
        }

        return null;
    }
}

if (!function_exists('get_or_insert_reference')) {
    function get_or_insert_reference(Builder $query, string $name, string $bundle, BridgeContent $bridge): ?array
    {
        /** @var Model|null $entity */
        $entity = $query->where('title', $name)->first();
        if ($entity) {
            return [$entity->uuid];
        }
        $uuidBridge = $bridge->contentInsert($bundle, [
            'title' => $name,
            'type' => 'node',
            'bundle' => $bundle,
        ]);

        if ($uuidBridge) {
            return [$uuidBridge];
        }

        return null;
    }
}

if (!function_exists('get_entity')) {
    function get_entity(array $record, BridgeContent $bridge, string $bundle, string $column): ?array
    {
        if (!array_key_exists($column, $record)) {
            return null;
        }
        $name = trim($record[$column]);

        if (empty($name)) {
            return null;
        }
        $query = call_user_func('Inside\\Content\\Models\\Contents\\'.\Illuminate\Support\Str::studly($bundle).'::get');

        if (Str::contains($name, ',')) {
            $dataUuid = [];
            $names = explode(',', $name);
            foreach ($names as $name) {
                $uuidReference = get_or_insert_reference($query, trim($name), $bundle, $bridge);
                if ($uuidReference) {
                    $dataUuid = array_merge($dataUuid, $uuidReference);
                }
            }

            return $dataUuid;
        }

        return get_or_insert_reference($query, $name, $bundle, $bridge);
    }
}

return [
    'files' => [
        'agfr' => [
            'path' => __DIR__.'/../../../../imports/import.csv',
            'separator' => ';',
            'fields' => [
                'name' => function ($record) {
                    return trim($record['e-mail']);
                },
                'mail' => function ($record) {
                    return trim($record['e-mail']);
                },
                'firstname' => function ($record) {
                    return ucwords($record['prénom']);
                },
                'lastname' => function ($record) {
                    return ucwords($record['nom']);
                },
                'phone' => function ($record) {
                    return get_string($record, 'téléphone');
                },
                'mobile' => function ($record) {
                    return get_string($record, 'mobile');
                },
                'sectors' => function ($record) {
                    return trim($record['secteur']);
                },
                'city' => function ($record) {
                    return trim($record['ville']);
                },
                'departments' => function ($record, \Inside\Host\Bridge\BridgeContent $bridge) {
                    return get_entity($record, $bridge, 'departments', 'département');
                },
                'status' => function () {
                    return 1;
                },
                'users_status' => function () {
                    return UsersStatus::where('title', 'Franchisé')->pluck('uuid')->toArray();
                },
            ],
        ],
    ],
    'cleandata' => function (&$data) {
        if ($data['image'] === false) {
            unset($data['image']);
        }
    },
];
