<?php

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

if (!function_exists('get_agfr_entity')) {
    function get_agfr_entity(array $record, BridgeContent $bridge, string $bundle, string $column, string $field = 'title'): ?array
    {
        $name = trim(ucwords(strtolower($record[$column])));

        if (empty($name) || $name === 'Null') {
            return null;
        }

        $query = call_user_func(type_to_class($bundle) . '::query');

        $entity = $query->where($field, $name)->first();

        if ($entity) {
            return [$entity->uuid];
        }

        return null;
    }
}

if (!function_exists('get_agfr_file')) {
    function get_agfr_file(string $fileName, string $type = 'image'): ?string
    {
        $fileName = trim($fileName);
        $imgPath = "csv/files/$fileName";

        if (!Storage::exists($imgPath)) {
            return null;
        }

        if ($type === 'image' && !@is_array(getimagesize(Storage::path($imgPath)))) {
            return null;
        }

        $chunkId = Str::random(32);
        $temporaryFilePath = "chunks/$chunkId";
        $finalPath = "$temporaryFilePath/$fileName";
        Storage::copy($imgPath, $finalPath);

        return $finalPath;
    }
}

return [
    'folders' => [
        'settings' => [
            'run_twice' => true,
            'path'      => __DIR__ .'/../../../../storage/app/csv/folders.csv',
            'delimiter' => ',',
            'id' => 'old_id',
        ],
        'fields' => [
            'title' => 'libelle',
            'folders' => function ($record, BridgeContent $bridge, $otherFiles = []) {
                return get_agfr_entity($record, $bridge, 'folders', 'ce_parent', 'old_id');
            },
            'old_id' => function ($record, BridgeContent $bridge, $otherFiles = []) {
                return (int) $record['id'];
            },
            'created_at' => function ($record, BridgeContent $bridge, $otherFiles = []) {
                return date('Y-m-d H:i:s');
            }
        ],
    ],
    'articles' => [
        'settings' => [
            'run_twice' => false,
            'path'      => __DIR__ .'/../../../../storage/app/csv/articles.csv',
            'delimiter' => ',',
            'id' => 'old_id',
            'other_files' => [
                'users' => [
                    'settings' => [
                        'path'      => __DIR__ .'/../../../../storage/app/csv/users.csv',
                        'delimiter' => ',',
                        'id' => 'id_compte',
                        'multiple' => false,
                    ],
                    'columns' => ['id_compte', 'login']
                ],
                'files' => [
                    'settings' => [
                        'path'      => __DIR__ .'/../../../../storage/app/csv/files.csv',
                        'delimiter' => ',',
                        'id' => 'id',
                        'multiple' => false,
                    ],
                    'columns' => ['id', 'nomfichier', 'libelle']
                ],
                'articles_files' => [
                    'settings' => [
                        'path'      => __DIR__ .'/../../../../storage/app/csv/articles_files.csv',
                        'delimiter' => ',',
                        'id' => 'ce_article',
                        'multiple' => true,
                    ],
                    'columns' => ['ce_fichier']
                ],
            ],
        ],
        'fields' => [
            'title' => 'titre',
            'folders' => function ($record, BridgeContent $bridge, $otherFiles = []) {
                return get_agfr_entity($record, $bridge, 'folders', 'ce_categorie', 'old_id');
            },
            'old_id' => function ($record, BridgeContent $bridge, $otherFiles = []) {
                return (int) $record['id'];
            },
            'created_at' => function ($record, BridgeContent $bridge, $otherFiles = []) {
                return date('Y-m-d H:i:s', strtotime($record['datecreation']));
            },
            'image' => function ($record, BridgeContent $bridge, $otherFiles = []) {
                if (trim(strtolower($record['ce_image1'])) === 'null') {
                    return null;
                }

                if (!array_key_exists($record['ce_image1'], $otherFiles['files'])) {
                    return null;
                }

                return get_agfr_file($otherFiles['files'][$record['ce_image1']]['nomfichier']);
            },
            'content' => function ($record, BridgeContent $bridge, $otherFiles = []) {
                $sections = [];

                if (trim(strtolower($record['ce_image2'])) !== 'null' && array_key_exists($record['ce_image2'], $otherFiles['files'])) {
                    $file = get_agfr_file($otherFiles['files'][$record['ce_image2']]['nomfichier']);

                    if ($file) {
                        $sections[] = [
                            'bundle' => 'image',
                            'image' => $file,
                        ];
                    }
                }

                if (!empty(trim($record['texte']))) {
                    $sections[] = [
                        'bundle' => 'text',
                        'body' => trim($record['texte']),
                    ];
                }

                if (array_key_exists($record['id'], $otherFiles['articles_files']) && !empty($otherFiles['articles_files'][$record['id']])) {
                    foreach ($otherFiles['articles_files'][$record['id']] as $file) {
                        if (!array_key_exists($file['ce_fichier'], $otherFiles['files'])) {
                            continue;
                        }

                        $path = get_agfr_file($otherFiles['files'][$file['ce_fichier']]['nomfichier'], 'file');

                        if (empty($path)) {
                            continue;
                        }

                        $title = trim($otherFiles['files'][$file['ce_fichier']]['libelle']);

                        $sections[] = [
                            'bundle' => 'file',
                            'file' => $path,
                            'title' => strtolower($title) !== 'null' ? $title : '',
                        ];
                    }
                }

                return $sections;
            },
            'author' => function ($record, BridgeContent $bridge, $otherFiles = []) {
                if (empty(trim($record['ce_compte'])) || trim(strtolower($record['ce_compte'])) === 'null') {
                    return null;
                }

                if (!array_key_exists($record['ce_compte'], $otherFiles['users'])) {
                    return null;
                }

                $user = Users::query()->where('email', trim($otherFiles['users'][$record['ce_compte']]['login']))->first();

                if (!$user) {
                    return null;
                }

                return $user->uuid;
            },
            'visible' => function ($record, BridgeContent $bridge, $otherFiles = []) {
                if (empty(trim($record['visibleemployes'])) || trim(strtolower($record['visibleemployes'])) === 'null') {
                    return 0;
                }

                return (int) trim($record['visibleemployes']);
            }
        ],
    ],
];
