<?php

use Illuminate\Support\Collection;
use Inside\Host\Bridge\BridgeContent;

if (! function_exists('get_entity_reference')) {
    function get_entity_reference(BridgeContent $bridge, string $contentType, ?string $value, bool $create = true, string $identifier = 'title'): ?string
    {
        if (empty($value)) {
            return null;
        }

        $existing = type_to_class($contentType)::where($identifier, $value)->first()?->uuid;

        if (! $create) {
            return $existing;
        }

        return $existing ?? $bridge->contentInsert($contentType, [$identifier => $value]);
    }
}

return [
    'postfilter' => function (Collection $users) {
        return $users->filter(fn (mixed $user) => $user->accountEnabled && isset($user->employeeId));
    },
    'sync_attributes' => [
        'name' => 'mail',
        'email' => 'mail',
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'function' => 'jobTitle',
        'is_maintenance' => fn () => false,
        'status' => fn () => true,
        'phone' => fn (mixed $user) => $user->businessPhones[0] ?? null,
        'directions' => fn (mixed $user, BridgeContent $bridge) => get_entity_reference($bridge, 'directions', $user->department),
        'locations' => fn (mixed $user, BridgeContent $bridge) => get_entity_reference($bridge, 'locations', $user->city),
        'agencies' => fn (mixed $user, BridgeContent $bridge) => get_entity_reference($bridge, 'agencies', $user->companyName),
        'manager' => fn (mixed $user, BridgeContent $bridge) => get_entity_reference(
            bridge: $bridge,
            contentType: 'users',
            value: $user->manager,
            create: false,
            identifier: 'name'
        ),
    ],
    'custom_attributes' => [
        'manager' => 'mail',
    ],
];
