import Google from '@inside-auth/components/login/extra-component/Google'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  'inside-auth': {
    extraComponent: {
      is: Google,
      link: `${origin}/google/login`
    }
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-news': {
    bookmarkEnabled: false
  },
  'inside-users': {
    shortcuts: {
      max: 5
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          { functions: ['uuid', 'title'] },
          { marker: ['uuid', 'title'] }
        ]
      }
    }
  }
}
