import { http } from '@inside-library/helpers/Http'
import { userFields } from '../../constants'

export const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'introduction',
        'banner',
        'presentation',
        'slug',
        'content_type',
        'admin',
        {
          users: {
            fields: userFields,
            filters: { sort: 'firstname:asc' }
          }
        },
        {
          tools: [
            'uuid',
            'title',
            'image',
            'icon',
            'has_section',
            'tools_link',
            'content_type',
            'admin',
            'published_at',
            {
              tools_categories: [
                'uuid',
                { tools_categories_listings: ['uuid', 'slug'] }
              ]
            }
          ]
        },
        {
          documents: [
            'uuid',
            'title',
            'file',
            'has_section',
            'admin',
            'content_type',
            'published_at'
          ]
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'image',
                    'chapo',
                    'content_type',
                    'published_at',
                    { news_categories: ['uuid', 'title'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    'published_at:lte': 'now()',
                    sort: 'published_at:desc',
                    limit: 4
                  }
                }
              }
            ]
          }
        },
        { pages_categories: { fields: ['count'], filters: { reverse: true } } }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
