import { userFields } from '../inside-customs/constants'

export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'image',
      'firstname',
      'lastname',
      'phone',
      'email',
      'marker',
      'mobile',
      'functions',
      'hide_from_directory'
    ]
  },
  documents: {
    modalFields: [
      'uuid',
      'title',
      'file',
      'content',
      'published_at',
      'updated_at',
      { folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  marker: {
    modalFields: [
      'uuid',
      'content_type',
      'title',
      'content',
      'address',
      'schedules',
      'image',
      'link',
      'phone',
      'content',
      { users: userFields }
    ]
  },
  vacations: {
    extendedUrl: ['uuid'],
    editionDisabled: true,
    modalFields: [
      'title',
      'uuid',
      'date',
      'end_date',
      'comment',
      'start_timeframes',
      'end_timeframes',
      { authors: ['uuid', 'image', 'firstname', 'lastname'] },
      { validator: ['uuid', 'image', 'firstname', 'lastname'] },
      { vacations_status: ['uuid', 'color', 'title', 'value'] }
    ]
  },
  groups_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'created_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { groups_folders: ['title'] }
    ]
  }
}
