<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/agen-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/agen-back/resources/assets/img/newsletter/header.jpg',
        'backgroundColor' => '#fff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#66CAF6',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#66CAF6',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'defaultCategoryColor' => '#66CAF6',
            'link' => [
                'sectionLinkUrl'   => 'evenements',
                'sectionTextColor' => '#66CAF6',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#66CAF6'
            ],
        ],
        'activities' => [
            'link'        => null, // Pas de links
            'orientation' => 'horizontal',
            'defaultBackgroundColor' => '#FFFFF',
            'defaultValueColor' => '#66CAF6',
            'items'       => [
                'comments' => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\Comments::count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/agen-back/resources/assets/img/newsletter/comments.png',
                    'titleStrKey'        => 'newsletter.comments_statistic',
                ],
                'likes'    => [
                    'callback'           => function () {
                        return \Inside\Reaction\Models\Reaction::where('type',
                            'like')->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/agen-back/resources/assets/img/newsletter/likes.png',
                    'titleStrKey'        => 'newsletter.likes_statistic',
                ],
                'users'    => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\Users::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/agen-back/resources/assets/img/newsletter/users.png',
                    'titleStrKey'        => 'newsletter.users_statistic',
                ],
                'news'     => [
                    'callback'           => function () {
                        return \Inside\Content\Models\Contents\News::where('status',
                            true)->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/agen-back/resources/assets/img/newsletter/news.png',
                    'titleStrKey'        => 'newsletter.contents_statistic',
                ],
            ],
        ]
    ],
    'socials'      => [
        'backgroundColor' => '#66CAF6',
        'links' => [
            'facebook' => [
                'url' => 'https://fr-fr.facebook.com/Agenor.fr',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/agenor-groupe',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
