<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateSpacesUsersFieldWidget extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'spaces',
            fieldName: 'users',
            options: [
                'name' => 'users',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Contacts clés',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => 3,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'users',
                    'cardinality' => -1,
                ],
                'selectable_all' => false,
            ],
            weight: 3
        );
        $this->finishUp();
    }
}
