<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Functions;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class SwitchFunctionsFieldToReference extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('functions');
        $this->migrateContent('users');

        $this->finishUp();

        $output = $this->getConsole();
        $bridge = new BridgeContent();
        $bridgeContentType = new BridgeContentType();
        $functions = [];
        $output->write('starting to get all users functions ...');
        Users::each(function ($user) use (&$functions) {
            if ($user->function) {
                $functions[$user->uuid] = $user->function;
            }
        });
        $output->writeln(' <fg=green>✔</fg=green>');
        $bridgeContentType->contentTypeDeleteField('user', 'user', 'function');

        foreach ($functions as $uuid => $function) {
            /** @var string $function */
            $output->write(sprintf('trying to get the function %s ...', $function));
            $functionUuid = Functions::query()->where('title', $function)->first();
            if (! $functionUuid) {
                $output->writeln(' <fg=red>x</fg=red>');
                $output->write(sprintf('Trying to create the content %s ...', $function));
                $functionUuid = $bridge->contentInsert('functions', [
                    'title' => $function,
                    'type' => 'node',
                    'bundle' => 'functions',
                ]);

                if (! $functionUuid) {
                    $output->writeln(' <fg=red>x</fg=red>');
                    $output->writeln(sprintf('Failed to create content %s for user %s ! Skipping', $function, $uuid));
                    continue;
                }
                $output->writeln(' <fg=green>✔</fg=green>');
            }
            $output->writeln(' <fg=green>✔</fg=green>');
            $bridge->contentUpdate('users', [
                'uuid' => $uuid,
                'functions' => $functionUuid,
            ]);
        }
    }

    public function down(): void
    {
    }
}
