<?php

use Illuminate\Support\Str;

return [
    'postfilter' => function ($users) {
        return $users->reject(function ($user) {
            $organizations = $user->getOrganizations();

            if (! isset($organizations[0]['department'])) {
                return true;
            }

            $department = Str::lower($organizations[0]['department']);

            return ! Str::contains($department, ['agenor', 'holding bfc', 'techniforma']);
        });
    },
];
