<?php

namespace Inside\AGEN\Services;

use Illuminate\Support\Str;
use Inside\Host\Bridge\BridgeContent;
use League\Csv\Exception;
use League\Csv\Reader;

/**
 * Class CsvImportService
 */
class CsvImportService
{
    /**
     * @param string $path
     * @param string $delimiter
     * @return array
     * @throws Exception
     */
    public function getRecords(string $path, string $delimiter = ';'): array
    {
        if (! file_exists($path)) {
            throw new \Exception('file not found');
        }
        $csv = Reader::createFromPath($path, 'r');

        $encoding = mb_detect_encoding($csv->getContent(), mb_list_encodings(), true);

        if ($encoding !== 'UTF-8') {
            $csv->setOutputBOM(Reader::BOM_UTF8);
            $csv->addStreamFilter('convert.iconv.'.$encoding.'/UTF-8');
        }

        $csv->setDelimiter($delimiter);
        $csv->setHeaderOffset(0);

        $headers = array_map(
            function ($item) {
                return trim(strtolower($item));
            },
            $csv->getHeader()
        );

        return iterator_to_array($csv->getRecords($headers));
    }
}
