<?php

namespace Inside\AGEN\Providers;

use Inside\AGEN\Console\ImportMarkers;
use Inside\Providers\ServiceProvider as BaseServiceProvider;

/**
 * AGEN Service provider.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__.'/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(
            __DIR__.'/../../config/scheduler.php',
            'scheduler'
        );
        $this->mergeConfigTo(__DIR__.'/../../config/google.php', 'google');
        $this->mergeConfigTo(__DIR__.'/../../config/csv.php', 'csv');
        $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
        $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
        $this->mergeConfigTo(__DIR__.'/../../config/import.php', 'import');

        $this->app->singleton(
            'command.agen.marker',
            function ($app) {
                return new ImportMarkers();
            }
        );

        $this->commands('command.agen.marker');
    }
}
