<?php

namespace Inside\AGEN\Console;

use Illuminate\Console\Command;
use Inside\AGEN\Facades\CsvImporter;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class ImportMarkers extends Command
{
    /**
     * @var string
     */
    protected $name = 'agen:marker:import';

    /**
     * @var string
     */
    protected $signature = 'agen:marker:import { --P|path=}';

    /**
     * @var string
     */
    protected $description = 'Import des implantations';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    private function getUser(string $email): ?string
    {
        $user = Users::query()->where('email', trim($email))->first();

        if ($user) {
            return $user->uuid;
        }

        return null;
    }

    private function importMarkers(array $markers): void
    {
        $bridge = new BridgeContent();

        foreach ($markers as $marker) {
            $data = [
                'type' => 'node',
                'bundle' => 'marker',
                'title' => trim($marker['nom']),
                'address' => trim($marker['adresse']).', '.trim($marker['cp']).' - '.trim($marker['ville']),
                'phone' => trim($marker['téléphone']),
                'users' => $this->getUser($marker['email']),
                'latitude' => trim($marker['latitude']),
                'longitude' => trim($marker['longitude']),
                'content' => [
                    [
                        'bundle' => 'text',
                        'body' => trim($marker['description']),
                    ],
                ],
            ];

            $bridge->contentInsert('marker', $data);
        }
    }

    public function handle(): void
    {
        $filePath = __DIR__.'/../../../../../'.env('MARKER_FILE_PATH', 'imports/implantations.csv');
        $path = $this->option('path');

        if ($path) {
            $filePath = $path;
        }

        $markers = CsvImporter::getRecords($filePath);
        $this->importMarkers($markers);
    }
}
