<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateSpacesPagesWeightField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        collect(['spaces_pages', 'pages_categories'])
            ->each(function (string $type) {
                $this->getBridge()?->contentTypeCreateOrUpdateField(
                    type: $type,
                    fieldName: 'weight',
                    options: [
                        'name' => 'weight',
                        'searchable' => false,
                        'translatable' => false,
                        'search_result_field' => false,
                        'searchable_filter' => false,
                        'required' => false,
                        'weight' => 5,
                        'title' => [
                            'fr' => 'Ordre d\'affichage',
                        ],
                        'description' => [
                            'fr' => 'Le chiffre le plus bas remonte en 1er',
                        ],
                        'widget' => [
                            'type' => BridgeContentType::NUMBER_WIDGET,
                            'settings' => [],
                            'weight' => 5,
                        ],
                        'type' => BridgeContentType::INTEGER_FIELD,
                        'settings' => [
                            'cardinality' => 1,
                        ],
                        'default' => 0,
                    ],
                    weight: 5
                );
            });
        $this->finishUp();
    }
}
