<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class ReplayExportNotificationCreation extends Migration
{
    public function up(): void
    {
        DB::table('migrations')->whereIn('migration', [
            '2020_05_12_000000_create_export_notification',
            '2020_09_16_000000_fix_export_notification',
        ])->delete();
        Artisan::call('migrate', [
            '--realpath' => true,
            '--path' =>  cms_base_path('vendor/maecia/inside-content/database/migrations/2020_05_12_000000_create_export_notification.php'),
            '--force' => true,
        ]);
        Artisan::call('migrate', [
            '--realpath' => true,
            '--path' =>  cms_base_path('vendor/maecia/inside-content/database/migrations/2020_09_16_000000_fix_export_notification.php'),
            '--force' => true,
        ]);
    }
}
