<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateHideFromDirectoryField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'user',
            fieldName: 'hide_from_directory',
            options: [
                'name' => 'hide_from_directory',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Cacher de l\'annuaire',
                    'en' => 'Hide from look-up directory',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'default' => false,
            ],
            entityTypeId: 'user'
        );
    }

    public function down(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'hide_from_directory');
    }
}
