<?php

use Carbon\Exceptions\InvalidFormatException;
use Illuminate\Support\Arr;
use Illuminate\Support\Carbon;

if (! function_exists('get_date_from_format')) {
    function get_date_from_format(?string $date, string $format = 'Y-m-d'): ?string
    {
        if (empty($date)) {
            return null;
        }

        try {
            $datetime = Carbon::createFromFormat($format, $date);

            if (! $datetime instanceof Carbon) {
                return null;
            }

            return $datetime->startOfDay()->toDateTimeString();
        } catch (InvalidFormatException) {
            return null;
        }
    }
}

return [
    'sync_attributes' => [
        'mail' => 'getPrimaryEmail',
        'name' => 'getPrimaryEmail',
        'firstname' => fn (Google_Service_Directory_User $user) => Arr::get($user->getName(), 'givenName'),
        'lastname' => fn (Google_Service_Directory_User $user) => Arr::get($user->getName(), 'familyName'),
        'birthday' => fn (Google_Service_Directory_User $user) => carbonize('Y-m-d')->from(data_get($user->customSchemas, 'Information.Anniversaire'))->birthday(),
        'functions' => fn (Google_Service_Directory_User $user) => reference('functions')->from(Arr::get($user->getOrganizations(), '0.title'))->get(),
        'phone' => fn (Google_Service_Directory_User $user) => Arr::get(collect($user->getPhones())->firstWhere('type', 'work'), 'value'),
        'mobile' => fn (Google_Service_Directory_User $user) => Arr::get(collect($user->getPhones())->firstWhere('type', 'mobile'), 'value'),
        'marker' => fn (Google_Service_Directory_User $user) => reference('marker')
            ->from(preg_replace('#\s\s+#', ' ', Arr::get($user->getOrganizations(), '0.department')))
            ->usingLikeOperator()
            ->withoutCreation()
            ->get(),
    ],
];
