<?php

use Illuminate\Support\Str;
use Inside\User\Models\User;

return [
    'files' => [
        'agen' => [
            'path' => env('AGEN_USERS_PATH', __DIR__.'/../../../../imports/export_email.csv'),
            'separator' => ';',
            'fields' => [
                'name' => static fn ($record): string => trim($record['email']),
                'mail' => static fn ($record): string => trim($record['email']),
                'firstname' => static fn ($record): string => ucwords(Str::lower($record['prenom'])),
                'lastname' => static fn ($record): string => ucwords(Str::lower($record['nom marital'])),
                'function' => static fn ($record): string => Str::ucfirst(Str::lower($record['emploi'])),
                'birthday' => static fn ($record): ?string => carbonize('d/m/Y')->from($record['date naissance'])->birthday(),
                'marker' => static fn ($record): array => reference('marker')->from($record['agence'])->usingLikeOperator()->withoutCreation()->get(),
                'status' => static fn (): bool => true,
                'hide_from_directory' => static fn (): bool => true,
                'send_mail' => static fn (): bool => true,
            ],
        ],
    ],
    'postfilter' => static function ($users): array {
        // Remove user without email
        $filteredUser = $users->reject(fn ($user) => empty($user['email']));

        // Find emails already use with another auth provider
        $emailsToIgnore = User::query()
            ->whereIn('email', $filteredUser->pluck('email'))
            ->where('provider_name', '<>', 'agen')
            ->where('provider_type', '<>', 'csv')
            ->pluck('email')
            ->toArray();

        // Remove then
        return $filteredUser->whereNotIn('email', $emailsToIgnore)->values()->all();
    },
];
