export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'outlook',
        label: 'Outlook'
      }
    ]
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-events': {
    calendarImportEnabled: true
  },
  'inside-jobs': {
    modalName: 'job-offers',
    extraFields: [
      { contracts_types: ['uuid', 'title'] },
      { services: ['uuid', 'title'] },
      { regions: ['uuid', 'title', 'color'] },
      { cities: ['uuid', 'title'] }
    ],
    categoriesFields: [
      {
        services: {
          fields: ['uuid', 'title'],
          filters: { 'status:eq': 1 }
        }
      },
      {
        regions: {
          fields: ['uuid', 'title', 'color'],
          filters: { 'status:eq': 1 }
        }
      }
    ]
  },
  'inside-news': {
    bookmarkEnabled: false,
    categoriesSubscriptionEnabled: true,
    categoriesSubscription: ['news_categories', 'regions'],
    minimalDate: true
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        {
          name: 'shortcuts',
          restrictions: [],
          icon: 'news',
          hideOnMobile: true
        },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'subscriptions', restrictions: [], icon: 'tag' }
      ]
    }
  },
  'inside-statistics': {
    contentsWithStats: ['news', 'events', 'documents', 'jobs_offers']
  },
  'inside-workflows': {
    isEnabled: true
  }
}
