import insideConfig from './inside.config.js'
import i18n from './i18n'
import redirections from './redirections'
import routes from './router'

import FooterLayouts from '../inside-overrides/inside-layouts/FooterLayouts'
import HorizontalLayouts from '../inside-overrides/inside-layouts/HorizontalLayouts'
import MapModal from '../inside-overrides/inside-maps/MapModal'
import UserModal from '../inside-overrides/inside-users/UserModal'

export default {
  name: 'inside-customs',
  init: app => {
    app.component('footer-layouts', FooterLayouts)
    app.component('horizontal-layouts', HorizontalLayouts)
    app.component('map-modal', MapModal)
    app.component('user-modal', UserModal)
  },
  insideConfig,
  i18n,
  redirections,
  routes
}
