import SpacePage from '../pages/spaces/SpacePage'
import TabSpacePage from '../pages/spaces/TabSpacePage'

import { fetchSpace } from '../components/spaces/fetch'

import { withFetch } from 'inside-collection/hocs'

import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/news/NewsListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'CseNewsListingPage',
    component: () => import('../pages/news/CseNewsListingPage'),
    path: { fr: 'actualites-cse', en: 'news-works-council' },
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          'archived:eq': 0,
          sort: 'weight:asc'
        },
        fields: [...folderContents.folders.fields]
      }
    }
  },
  {
    name: 'ProfileShortcuts',
    meta: { hideOnMobile: true }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false, hideOnMobile: true },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/users/DirectoryPage')
  },
  {
    name: 'AdsListingPage',
    props: {
      add: ['postings']
    }
  },
  {
    name: 'JobsListingPage',
    component: () => import('../pages/jobs/JobsListingPage')
  },
  {
    name: 'MapPage',
    component: () => import('../pages/maps/MapPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'SpacesListingPage',
    component: () => import('../pages/spaces/SpacesListingPage'),
    path: {
      fr: '/espaces',
      en: '/spaces'
    }
  },
  {
    name: 'SpacePage',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace),
    path: {
      fr: '/espaces/:slug',
      en: '/spaces/:slug'
    },
    meta: { content: 'spaces' }
  },
  {
    name: 'TabSpacePage',
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchSpace
    ),
    path: {
      fr: '/espaces/pages/:slug',
      en: '/spaces/pages/:slug'
    },
    alias: ['/fr/espaces/:slug/pages', '/en/spaces/:slug/pages'],
    meta: { content: 'spaces' }
  }
]
